/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.chickens.blockentities;

import java.util.Random;
import javax.annotation.Nonnull;
import net.creeperhost.chickens.capability.SmartInventory;
import net.creeperhost.chickens.containers.ContainerRoost;
import net.creeperhost.chickens.data.ChickenStats;
import net.creeperhost.chickens.init.ModBlocks;
import net.creeperhost.chickens.init.ModItems;
import net.creeperhost.chickens.item.ItemChicken;
import net.creeperhost.chickens.registry.ChickensRegistry;
import net.creeperhost.chickens.registry.ChickensRegistryItem;
import net.creeperhost.chickens.util.InventoryHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockEntityRoost
extends BlockEntity
implements MenuProvider {
    public SmartInventory inventory = new SmartInventory(5){

        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            BlockEntityRoost.this.m_6596_();
            if (slot == 0) {
                BlockEntityRoost.this.progress = 0;
            }
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            if (slot == 0) {
                return stack.m_150930_((Item)ModItems.CHICKEN_ITEM.get());
            }
            return false;
        }

        @NotNull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (slot == 0) {
                return ItemStack.f_41583_;
            }
            return super.extractItem(slot, amount, simulate);
        }

        @NotNull
        public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
            if (slot > 0) {
                return stack;
            }
            return super.insertItem(slot, stack, simulate);
        }

        public int getSlotLimit(int slot) {
            if (slot == 0) {
                return 16;
            }
            return super.getSlotLimit(slot);
        }
    };
    public final ContainerData containerData = new SimpleContainerData(1){

        public int m_6413_(int index) {
            if (index == 0) {
                return BlockEntityRoost.this.progress;
            }
            throw new IllegalArgumentException("Invalid index: " + index);
        }

        public void m_8050_(int index, int value) {
            throw new IllegalStateException("Cannot set values through IIntArray");
        }

        public int m_6499_() {
            return 1;
        }
    };
    public int progress = 0;

    public BlockEntityRoost(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)ModBlocks.ROOST_TILE.get(), blockPos, blockState);
    }

    public void m_6596_() {
        super.m_6596_();
        if (this.f_58857_ != null) {
            this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
        }
    }

    public void tick() {
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            if (this.canRun()) {
                if (this.progress <= 1000) {
                    this.progress += this.getProgressValue(this.inventory.getStackInSlot(0));
                } else {
                    ItemStack inserted = InventoryHelper.insertItemStacked(this.inventory, this.getOutputStack(), false);
                    if (inserted.m_41619_()) {
                        this.f_58857_.m_5594_(null, this.m_58899_(), SoundEvents.f_11752_, SoundSource.NEUTRAL, 0.5f, 0.8f);
                        this.spawnParticle(this.f_58857_, this.m_58899_().m_123341_(), this.m_58899_().m_123342_() + 1, this.m_58899_().m_123343_(), this.f_58857_.f_46441_);
                        this.progress = 0;
                    }
                }
            } else {
                this.progress = 0;
            }
        }
    }

    public int getProgressValue(ItemStack itemStack) {
        ChickenStats chickenStats = new ChickenStats(itemStack);
        int count = itemStack.m_41613_();
        int value = chickenStats.getGrowth() + count + 1;
        return Math.min(value, 50);
    }

    public boolean canRun() {
        if (this.inventory.getStackInSlot(0).m_41619_()) {
            return false;
        }
        if (!(this.inventory.getStackInSlot(0).m_41720_() instanceof ItemChicken)) {
            return false;
        }
        ItemStack insert = InventoryHelper.insertItemStacked(this.inventory, this.getOutputStack(), true);
        return insert.m_41619_();
    }

    public ItemStack getOutputStack() {
        ChickensRegistryItem chickensRegistryItem = ChickensRegistry.getByRegistryName(ItemChicken.getTypeFromStack(this.inventory.getStackInSlot(0)));
        if (chickensRegistryItem != null) {
            ChickenStats chickenStats = new ChickenStats(this.inventory.getStackInSlot(0));
            int gain = chickenStats.getGain();
            int chickens = this.inventory.getStackInSlot(0).m_41613_();
            ItemStack itemToLay = chickensRegistryItem.createLayItem();
            if (gain >= 5) {
                itemToLay.m_41769_(chickensRegistryItem.createLayItem().m_41613_());
            }
            if (gain >= 10) {
                itemToLay.m_41769_(chickensRegistryItem.createLayItem().m_41613_());
            }
            int finalCount = itemToLay.m_41613_() * chickens;
            itemToLay.m_41764_(finalCount);
            return itemToLay;
        }
        return ItemStack.f_41583_;
    }

    public void spawnParticle(Level worldIn, double posX, double posY, double posZ, Random rand) {
        for (int i = 0; i < 16; ++i) {
            int j = rand.nextInt(2) * 2 - 1;
            int k = rand.nextInt(2) * 2 - 1;
            double d0 = posX + 0.5 + 0.25 * (double)j;
            double d1 = (float)posY + rand.nextFloat();
            double d2 = posZ + 0.5 + 0.25 * (double)k;
            double d3 = rand.nextFloat() * (float)j;
            double d4 = ((double)rand.nextFloat() - 0.5) * 0.125;
            double d5 = rand.nextFloat() * (float)k;
            worldIn.m_7106_((ParticleOptions)ParticleTypes.f_123750_, d0, d1, d2, d3, d4, d5);
        }
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_183216_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    @NotNull
    public CompoundTag m_5995_() {
        CompoundTag compoundTag = new CompoundTag();
        compoundTag.m_128391_(this.inventory.serializeNBT());
        return compoundTag;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @javax.annotation.Nullable Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return LazyOptional.of(() -> this.inventory).cast();
        }
        return super.getCapability(cap, side);
    }

    protected void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        compound.m_128391_(this.inventory.serializeNBT());
        compound.m_128405_("progress", this.progress);
    }

    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        this.inventory.deserializeNBT(compound);
        this.progress = compound.m_128451_("progress");
    }

    @NotNull
    public Component m_5446_() {
        return new TextComponent("chickens.container.roost");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int id, Inventory inventory, Player p_39956_) {
        return new ContainerRoost(id, inventory, this, this.containerData);
    }
}

